<?xml version="1.0"?>
<xsl:stylesheet>
<xsl:output omit-xml-declaration="true" method="html" indent="no"/>
<xsl:include href="movieCommon.xsl"/>

<!-- Parameters for assigning a unique names to the graphical elements
	on the page. These can be set from Java in XSLTProcessor object.
-->
<xsl:param name="movieNum" select="'default'"/>
<xsl:param name="aveRating" select="'2.5'"/>
<xsl:param name="movieArtRoot" select="'cover_art'"/>
<xsl:param name="productPage" select="'default'"/>
<xsl:param name="itemIDParam" select="'default'"/>
<xsl:param name="itemID"  select="'default'"/>
<xsl:param name="addMyListParam" select="'default'"/>

<xsl:template name="productURL">
	<xsl:value-of select="$productPage"/>?<xsl:value-of select="$itemIDParam"/>=<xsl:value-of select="$itemID"/>
</xsl:template>

<!--	Template for document root. Prevents the regurgitation of bad XML
-->
<xsl:template match="/">
	<xsl:apply-templates select="MOVIE"/>
</xsl:template>

<!-- Template for the movie: outputs a checkbox for adding the movie
	to the user's MyList, and the title of the movie which links to the
	product page.
-->
<xsl:template match="/MOVIE">
	<xsl:param name="prodURL">
		<xsl:call-template name="productURL"/>
	</xsl:param>
		<div id="greenback" style="width:110"> 
			<span id="smalltext">&#160;add to my list</span>
			<input type="checkbox" id="normaltext">
				<xsl:attribute name="name"><xsl:value-of select="$addMyListParam"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$itemID"/></xsl:attribute>
			</input>
		</div>
		<a id="movieLink"><xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute>
			<b>	<xsl:call-template name="movieLongName"/>	</b>
		</a><p/>

			  
   
</xsl:template>

</xsl:stylesheet>


